<?php

class Module {
    private static function getSEO() {
        if (file_exists($_SERVER["DOCUMENT_ROOT"] . "/data/SEO.xml"))
            return simplexml_load_file($_SERVER["DOCUMENT_ROOT"] . "/data/SEO.xml");
        else
            return FALSE;
    }
    
    private static function saveSEO($xml) {
        $xml->asXml($_SERVER["DOCUMENT_ROOT"] . "/data/SEO.xml");
    }

    public static function isPage($module)
    {
        $modules = $module -> xpath("../..");
        return $modules[0] -> getName() == "page";
    }

    public static function create($module) {
        if (!Module::getSEO()) {
            $xml = new SimpleXMLElement('<?xml version="1.0" encoding="utf-8"?><config></config>');
            $xml -> asXml($_SERVER["DOCUMENT_ROOT"] . "/data/SEO.xml");
        }

        
        $xml = Module::getSEO();

        if (Module::isPage($module)) {
            $attr = $modules[0] -> attributes();
            
            $p = $xml->addChild("page");
            $p->addAttribute("uniqueId", $attr["uniqueId"]);
            $p->addChild("description");
            
        } else {
            $p = $xml->addChild("site");
        }
        
        $p->addChild("keywords");
        
        Module::saveSEO($xml);
        
    }
    
    public static function getSEOdata($page)
    {
        $xml = Module::getSEO();
        if(is_null($page)) {
            $site = $xml -> config -> site;
            return $site;
        } else {
            $attr = $page -> attributes();
            $uid = $attr["uniqueId"];
            $pages = $xml -> xpath("//config/page[@uniqueId=$uid]");
            return $pages[0];
        }
    }
    
    public static function getGlobalSEOdata()
    {
        $xml = Module::getSEO();
        
            $site = $xml -> config -> site;
            return $site;
        
    }

    public static function save($module, $post, $files, $get) {
        $modules = $module -> xpath("../..");
        $attr = $modules[0] -> attributes();
        
        $xml = Module::getSEO();
        if(Module::isPage($module)) {
            $uid = $attr["uniqueId"];
            $pages = $xml -> xpath("//config/page[@uniqueId=$uid]");
            $page = $pages[0];
            
            $page -> description = htmlentities($post["description"]);
            $page -> keywords = htmlentities($post["keywords"]);
        } else {
            $xml -> config -> site -> keywords = htmlentities($post["keywords"]);
        }
        
        Module::saveSEO($xml);

    }

    public static function delete($module) {

    }

}
?>