<?php

class Actualis {

    public static function actionLink($action) {

        $link = "admin-panel.php?";
        foreach ($_GET as $id => $val) {

            if ($id != "action" && ($id == "type" || $id == "modulename" || $id == 'id'))
                $link .= "$id=$val&";
            elseif ($id == "action")
                $link .= "$id=$action&";
        }

        return substr($link, 0, -1);
    }

    public static function listModules() {
        $modules = array();
        $path = $_SERVER["DOCUMENT_ROOT"] . "/modules";
        $dir = opendir($path);

        while ($element = readdir($dir)) {
            if ($element != '.' && $element != '..' && is_dir($path."/".$element))
                $modules[] = $element;
        }

        return $modules;
    }

    public static function getMetaModule($type) {
        $xml = simplexml_load_file($_SERVER["DOCUMENT_ROOT"] . "/modules/$type/details.xml");
        return $xml;
    }

    public static function includeParams($module) {
        $type = $module -> type;
        $params = $module -> params;
        $parent = $module->xpath("../..");
        $page = null;
        if($parent[0]->getName() == "page")
            $page = $parent[0];
        if (file_exists($_SERVER["DOCUMENT_ROOT"] . "/modules/$type/params.inc"))
            include ($_SERVER["DOCUMENT_ROOT"] . "/modules/$type/params.inc");
        if (Auth::isAdmin() && file_exists($_SERVER["DOCUMENT_ROOT"] . "/modules/$type/admin_params.inc"))
            include ($_SERVER["DOCUMENT_ROOT"] . "/modules/$type/admin_params.inc");
    }

    public static function createModule($module) {
        $type = $module -> type;
        require_once ($_SERVER["DOCUMENT_ROOT"] . "/modules/$type/functions.php");
        Module::create($module);
    }

    public static function saveModule($module, $post, $files, $get) {
        $type = $module -> type;
        require_once ($_SERVER["DOCUMENT_ROOT"] . "/modules/$type/functions.php");
        $params = $module -> params;
        Module::save($module, $post, $files, $get);
    }

    public static function deleteModule($module) {
        $type = $module -> type;
        require_once ($_SERVER["DOCUMENT_ROOT"] . "/modules/$type/functions.php");
        $params = $module -> params;
        Module::delete($module);
    }

    public static function uninstallModule($module) {
           
        $dir = $_SERVER["DOCUMENT_ROOT"] . '/modules/' . $module . "/";
        
        if (is_dir($dir)) {
            $objects = scandir($dir);
            foreach ($objects as $object) {
                if ($object != "." && $object != "..") {
                    if (filetype($dir . "/" . $object) == "dir")
                        rrmdir($dir . "/" . $object);
                    else
                        unlink($dir . "/" . $object);
                }
            }
            reset($objects);
            rmdir($dir);

        }
    }

}
?>