<?php $fichiers = scandir($_SERVER["DOCUMENT_ROOT"] . '/actualis/modules');

$modules = array();
foreach ($fichiers as $fichier) {
    
    if (!is_dir($fichier)) {
        
        $nom = preg_replace('#(.*)\-v\.(.*)\.(.*)\.zip#', '$1', $fichier);
        $version = preg_replace('#.*\-v\.(.*)\.(.*)\.zip#', '$1.$2', $fichier);
        
        $zip = new ZipArchive;
        $res = $zip->open($_SERVER["DOCUMENT_ROOT"] . '/actualis/modules/'.$fichier);
        
        $xml;
        if($res === TRUE){
            $xml = simplexml_load_string($zip->getFromName('details.xml'));
        
        if (key_exists($nom, $modules)) {

            if (floatval($modules[$nom]["version"]) < floatval($version)) {

                $modules[$nom]["version"] = $version;
                $modules[$nom]["complet"] = $xml -> name;
                $modules[$nom]["description"] = $xml -> description ;
            }
        } else {
                $modules[$nom]["version"] = $version;
            
                $modules[$nom]["complet"] = $xml -> name;
                $modules[$nom]["description"] = $xml -> description ;
                        
            }
        }

    }

}

header('Content-Type: application/xml; charset=utf-8');
?>
<modules>
    <?php foreach($modules as $nom => $module) {
            $complet = $module["complet"];
            $version = $module["version"];
            $description = $module["description"];
            $texte = "<name>$nom</name><completename>$complet</completename><version>$version</version><description><![CDATA[$description]]></description>";
        ?>
    <module>
        <file><?php echo "$nom-v.$version.zip"; ?></file>
        <?php echo $texte ?>
    </module>
    <?php
    }
    ?>
</modules>