<?php
    if(!$site->getHomePage()) {
        echo $site->getHomePage();
        ?>
        <div class="alert alert-danger">Attention, il n'y a pas de page d'accueil définie par défaut !</div>
        <?php
    }

?>

<table class="table table-striped table-hover">
    <thead>
        <tr>
            <th>
                #
            </th>
            <th>
                Nom
            </th>
            <th>
                Permalien
            </th>
            <th>
                Ordre
            </th>
            <th>
                Accueil
            </th>
        </tr>
    </thead>
    <tbody>
        <?php
        $pages = $site->getPages();
        $total = count($pages);
        
        $i = 1;
        if($pages)
        {
            foreach($pages as $id => $page)
            {
                ?>
                <tr>
                    <td><?php echo $id; ?></td>
                    <td><a href="admin-panel.php?type=manage&action=editpage&id=<?php echo $id; ?>"><?php echo $page["name"]; ?></a></td>
                    <td><?php echo $page["permalink"]; ?></td>
                    <td>
                        <?php if($i != 1) { ?><a href="admin-panel.php?type=manage&action=movepage&direction=up&id=<?php echo $id; ?>" class="glyphicon glyphicon-arrow-up"></a><?php } ?>
                        <?php if($i != $total) { ?><a href="admin-panel.php?type=manage&action=movepage&direction=down&id=<?php echo $id; ?>" class="glyphicon glyphicon-arrow-down"></a><?php } ?>
                    </td>
                    <td>
                        <?php if($page["home"]) {?><div class="btn btn-success btn-xs"><span class="glyphicon glyphicon-star"></span></div><?php }
                        else { ?><a class="btn btn-primary btn-xs" href="admin-panel.php?type=manage&action=home&id=<?php echo $id; ?>" ><span class="glyphicon glyphicon-star-empty"></span></a><?php } ?>
                    </td>
                </tr>
                <?php
                $i++;
                }
            }
        ?>
    </tbody>
</table>


<div class="panel panel-info">
	<div class="panel-heading">
		<h3 class="panel-title">Créer une nouvelle page</h3>
	</div>
	<div class="panel-body">
		<form class="form-inline" action="admin-panel.php?type=manage&action=addpage" method="POST">
		    <div class="form-group">
                <label class="sr-only" for="pagename">Nom de la page</label>
                <input type="text" class="form-control" name="pagename" placeholder="Nom de la page" required>
            </div>
            <div class="form-group">
                <label class="sr-only" for="permalink">Permalien</label>
                <input type="text" class="form-control" name="permalink" placeholder="Permalien" required="">
            </div>
            <div class="form-group">
                <input type="submit" class="btn btn-info" value="Créer la page">
            </div>
		</form>
	</div>
</div>


