<?php
    $url  = 'http://repository.syltech.fr/actualis/list_available_modules.php';
 
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
 
    $data = curl_exec($ch);
 
    curl_close($ch);

    $xml = simplexml_load_string($data);
    
    $modules = $xml -> module;
    
    $listeModules = Actualis::listModules();

?>
<div class="page-header"><h1>Gestion des modules</h1></div>
<h2>Modules sur le repository</h2>
<table class="table table-striped table-hover">
    <thead>
        <tr>
            <th>
                Nom
            </th>
            <th>
                Description
            </th>
            <th>
                Version Disponible
            </th>
            <th>
                Version Installée
            </th>
            <th>
                Action
            </th>
        </tr>
    </thead>
    <tbody>
        <?php
           
        foreach($modules as $m)
        {
            echo "<tr>";
             $ligne = array();
             
             $ligne[] = $m->completename;
             $ligne[] = $m->description;
             $ligne[] = "v".$m->version;
             $installed = TRUE;
             $updated = TRUE;
             if(!in_array($m->name, $listeModules)) {
                 //LE MODULE N'EST PAS INSTALLE
                 $installed = FALSE;
                 $ligne[] = "Non installé";
             } else {
                 $meta = Actualis::getMetaModule($m->name);
                 
                 if(floatval($meta->version.".".$meta->subversion) < floatval($m->version)) {
                     $ligne[] = "<p class='text-danger'><strong>v".$meta->version.".".$meta->subversion."</strong></p>";
                     $updated = FALSE;
                 } else {
                     $ligne[] = "<p class='text-success'>v".$meta->version.".".$meta->subversion."</p>";
                 }
             }
             
             if($installed) {
                if($updated) {
                    $ligne[] = "";
                } else {
                    //On va chercher les informations de mise à jour
                    $url  = 'http://repository.syltech.fr/actualis/update_infos.php?module='.$m->name."&version=".$meta->version.".".$meta->subversion;
                    
                    $ch = curl_init($url);
                    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                 
                    $data = curl_exec($ch);
                 
                    curl_close($ch);
                
                    $xml = simplexml_load_string($data);
                    
                    $versions = $xml->update;
                    
                    $texte = "";
                    
                    foreach($versions as $version)
                    {
                        $texte .= "<h4 class='text-success'>v".$version["version"]." :</h4><p>".$version."</p>";
                    }
                    
                    
                    
                    
                    $lien = Actualis::actionLink("updateInstallModule")."&module=".$m->name."&file=".$m->file;
                    $ligne[] = "<a href='$lien' data-trigger='hover' data-placement='left' data-title='Mise à jour' data-html='true' data-content=\"$texte\"  class='btn btn-success pop'>Mettre à jour</a>";
                }
             } else {
                $lien = Actualis::actionLink("installModule")."&module=".$m->file;
                $ligne[] = "<a href='$lien' class='btn btn-primary'>Installer</a>";
             }
             
             foreach($ligne as $l)
             {
                 echo "<td>$l</td>";
             }
            
            echo "</tr>";
            
            ?>
    
    
        <?php } ?>
    </tbody>
</table>

<h2>Modules installés sur le site</h2>
<table class="table table-striped table-hover">
    <thead>
        <tr>
            <th>Nom</th>
            <th>Version</th>
            <th>Utilisé en pages</th>
            <th>Utilisé en général</th>
            <th>Total utilisation</th>
            <th>Actions</th>
        </tr>
    </thead>
    <tbody>
        <?php
        $xml = $site->getXml();
        foreach($listeModules as $m){
            $meta = Actualis::getMetaModule($m);
            $ligne = array();
            $ligne[] = "<p>".$meta->name."</p>";
            $ligne[] = "v".$meta->version.".".$meta->subversion;
            $utilpages = count($xml -> xpath("//site/pages/page/modules/module[type='$m']")); 
            $ligne[] = $utilpages;
            $utilgeneral =  count($xml -> xpath("//site/modules/module[type='$m']"));
            $ligne[] = $utilgeneral;
            $utiltotal = $utilpages + $utilgeneral; 
            $ligne[] = $utiltotal;
            
            if($utiltotal == 0)
                $ligne[] = "<a href='".Actualis::actionLink("uninstallmodule")."&module=$m' class='btn btn-danger'>Désinstaller</a>";
            else
                $ligne[] = "";
            
            if($utiltotal > 0)
                echo "<tr>";
            else
                echo "<tr class='text-danger'>";
            foreach($ligne as $l)
                echo "<td>$l</td>";
            echo "</tr>";
        }
        ?>
    </tbody>
</table>

<script language="javascript">
    $('.pop').popover()
</script>
