<?php
session_start();
require_once ("../utils/Site.php");
require_once ("../utils/Auth.php");
include ("../utils/Actualis.php");

if(!Auth::isLogged()){
    header("Location:index.php");
}

?>

<!DOCTYPE html>
<html>
  <head>
    <title>Administration - <?php echo $site->getSiteName(); ?></title>
    <meta http-equiv="content-type" 
        content="text/html;charset=utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <!-- Bootstrap -->
    <link href="css/bootstrap.min.css" rel="stylesheet">
    <link href="css/bootstrap-theme.min.css" rel="stylesheet">
    <!-- jQuery (necessary for Bootstrap's JavaScript plugins) -->
    <script src="js/jquery.js"></script>
    <!-- Include all compiled plugins (below), or include individual files as needed -->
    <script src="js/bootstrap.min.js"></script>

    <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
    <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
    <!--[if lt IE 9]>
      <script src="https://oss.maxcdn.com/libs/html5shiv/3.7.0/html5shiv.js"></script>
      <script src="https://oss.maxcdn.com/libs/respond.js/1.3.0/respond.min.js"></script>
    <![endif]-->
  </head>
  <body>
      
    <div class="navbar navbar-inverse navbar-static-top">
        
        <div class="container">
            <div class="navbar-header">
                <button type="button" class="navbar-toggle" data-toggle="collapse" data-target=".navbar-collapse">
                <span class="sr-only">Toggle navigation</span>
                <span class="icon-bar"></span>
                <span class="icon-bar"></span>
                <span class="icon-bar"></span>
              </button>
                <a class="navbar-brand" href="admin-panel.php">Administration</small></a>
            </div>
            <div class="collapse navbar-collapse">
					<ul class="nav navbar-nav">
						<li class="dropdown">
							<a href="#" class="dropdown-toggle" data-toggle="dropdown">Pages <b class="caret"></b></a>
							<ul class="dropdown-menu">
							    <?php
                                $pages = $site->getPages();
                                
                                if($pages)
                                {
                                    foreach($pages as $id => $page)
                                    {?>
    								<li>
    									<a href="admin-panel.php?type=pages&action=editpage&id=<?php echo $id; ?>"><span class="glyphicon glyphicon-file"></span> <?php echo $page["name"]; ?></a>
    								</li>
    								<?php
                                    }
                                }
                                ?> 
							</ul>
						</li>
                        <li class="dropdown">
                            <a href="#" class="dropdown-toggle" data-toggle="dropdown">Modules Généraux<b class="caret"></b></a>
                            <ul class="dropdown-menu">
                                <?php
                                $modules = $site->getGeneralModules();
                                
                                if($modules)
                                {
                                    foreach($modules as $m)
                                    {
                                        $meta = Actualis::getMetaModule($m->type);?>
                                    <li>
                                        <a href="admin-panel.php?type=generalmodules&action=editmodule&modulename=<?php echo $m->name; ?>"><span class="glyphicon glyphicon-<?php echo $meta->icon ?>"></span> <?php echo $m->short; ?></a>
                                    </li>
                                    <?php
                                    }
                                } else {
                                    ?>
                                    <li class="disabled"><a>Aucun module disponible</a></li>
                                    <?php
                                }
                                
                                ?>
                            </ul>
                        </li>
                        
                        <?php
                        if (Auth::isAdmin())
                        {
                        ?>
                        <li class="dropdown"><a href="#" class="dropdown-toggle" data-toggle="dropdown">Gestion du site <b class="caret"></b></a>
                            <ul class="dropdown-menu">
                                <li>
                                    <a href="admin-panel.php?type=manage&action=listpages">Pages</a>
                                </li>
                                <li>
                                    <a href="admin-panel.php?type=manage&action=listgeneralmodules">Modules généraux</a>
                                </li>
                                <li>
                                    <a href="admin-panel.php?type=manage&action=listavailablemodules">Installation de modules</a>
                                </li>
                                
                            </ul>
                        </li>
                        <?php
                        }
                        ?>
					</ul>
					<ul class="nav navbar-nav navbar-right">
					    <li class="dropdown">
                            <a href="#" class="dropdown-toggle" data-toggle="dropdown"><span class="glyphicon glyphicon-user"></span> Profil de <?php echo Auth::getName() ?> <b class="caret"></b></a>
                            <ul class="dropdown-menu">
                                <li>
                                    <a href="admin-panel.php?type=user&action=editprofile"><span class="glyphicon glyphicon-cog"></span> Modifier mes infos</a>
                                </li>
                                <li>
                                    <a href="logout.php"><span class="glyphicon glyphicon-log-out"></span> Se déconnecter</a>
                                </li>
                            </ul>
                        </li>
					</ul>
				</div>
        </div>
        
    </div>
    
    
    <div class="container">
        
        <?php if(isset($_GET["type"])) {
            include($_GET["type"]."/".$_GET["action"].".inc");
        } else {
            include("home.inc");
        }?>
    </div>
        
    
    

    
  </body>
</html>